/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

/* Combination Method:	 SubsetType 1,2,3 and 4.
   RefSet Update Method: Static Strategy */

#include "SS3e.h"

void SSCreate_RefSet(SS *pb)
{
	int b1,i,j,a,*p_order,*rs_order,*min_dist;

	/* Order solutions in P */
	p_order = SSOrder_i(pb->p->ObjVal,pb->p->PSize,1);

	/* Add the b1 best solutions in P to RefSet */
	b1 = pb->rs->b / 2;
	for(i=1;i<=b1;i++)
	{
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[p_order[i]][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[p_order[i]];
		pb->rs->iter[i]   = 1;
	}

	/* Compute minimum distances from P to RefSet */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);

	/* Add the diverse b-b1 solutions to RefSet */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[a];
		pb->rs->iter[i]   = 1;

		SSUpdate_distances(pb,min_dist,i);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder_i(pb->rs->ObjVal,pb->rs->b,1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;
	pb->CurrentIter      = 1;

	free(rs_order+1);free(p_order+1);free(min_dist+1);
}

void SSRebuild_RefSet(SS *pb)
{	
	int *min_dist;
	int b1,i,j,a,index,*rs_order;

	b1 = pb->rs->b / 2;

	/* Create a new set P */
	SSCreate_P(pb);

	/* Compute minimum distances from P to RefSet */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);
	
	/* Add the diverse b-b1 solutions to RefSet
	   (remove the worst b1 sols. in Refset) */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);
		index = pb->rs->order[i];

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[index][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[index] = pb->p->ObjVal[a];
		pb->rs->iter[index] = pb->CurrentIter;

		SSUpdate_distances(pb,min_dist,index);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder_i(pb->rs->ObjVal,pb->rs->b,1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;

	free(min_dist+1);free(rs_order+1);
}

void SSUpdate_RefSet(SS *pb)
{
	int a,value;

	pb->rs->NewSolutions=0;
	SSCombine_RefSet(pb);
	pb->CurrentIter++;

	for(a=1;a<=pb->pool_size;a++)
	{
		value=sol_value(pb,pb->pool[a]);
		SSImprove_solution(pb,pb->pool[a],&value);
		SSTryAdd_RefSet(pb,pb->pool[a],value);
	}

	pb->pool_size=0;
}

void SSCombine_RefSet(SS *pb)
{
	int i,j,a,b,c,d,s,onenewsol;
	int *newsol,*sols,*value;

	newsol = SSInt_array(pb->nvar);
	sols   = SSInt_array(pb->rs->b);
	value  = SSInt_array(pb->rs->b);

	/* Combine elements in RefSet */
	for(i=1;i<pb->rs->b;i++)
	for(j=i+1;j<=pb->rs->b;j++)
	{
		/****** SubsetType 1 ************/
		a=pb->rs->order[i];
		b=pb->rs->order[j];
		sols[1]=a;
		sols[2]=b;
		value[1]=pb->rs->ObjVal[a];
		value[2]=pb->rs->ObjVal[b];

		if(pb->rs->iter[a] == pb->CurrentIter ||
		   pb->rs->iter[b] == pb->CurrentIter)
		{
			SSCombine_nsol(pb,2,sols,value,newsol);
			pb->pool_size++;
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
		}

		if(j+1<=pb->rs->b)
		{
			/****** SubsetType 2 ************/
			c=pb->rs->order[j+1];
			sols[3]=c;
			value[3]=pb->rs->ObjVal[c];

			if(pb->rs->iter[a] == pb->CurrentIter ||
			   pb->rs->iter[b] == pb->CurrentIter ||
			   pb->rs->iter[c] == pb->CurrentIter)
			{
				SSCombine_nsol(pb,3,sols,value,newsol);
				pb->pool_size++;
				for(s=1;s<=pb->nvar;s++)
					pb->pool[pb->pool_size][s]=newsol[s];
			}
	
			if(j+2<=pb->rs->b)
			{
				/******  SubsetType 3  ************/
				d=pb->rs->order[j+2];
				sols[4]=d;
				value[4]=pb->rs->ObjVal[d];

				if(pb->rs->iter[a] == pb->CurrentIter ||
				   pb->rs->iter[b] == pb->CurrentIter ||
			       pb->rs->iter[c] == pb->CurrentIter ||
			       pb->rs->iter[d] == pb->CurrentIter)
				{
					SSCombine_nsol(pb,4,sols,value,newsol);
					pb->pool_size++;
					for(s=1;s<=pb->nvar;s++)
						pb->pool[pb->pool_size][s]=newsol[s];
				}
			}
		}
	}

	/********  SubsetType 4  ************/
	onenewsol=0;
	for(i=1;i<=pb->rs->b;i++)
	{
		a=pb->rs->order[i];
		sols[i]=a;
		value[i]=pb->rs->ObjVal[a];
		if(pb->rs->iter[a] == pb->CurrentIter)
			onenewsol=1;

		if(i>=5 && onenewsol)
		{
			SSCombine_nsol(pb,i,sols,value,newsol);
			pb->pool_size++;
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
		}
	}

	free(newsol+1);free(sols+1);free(value+1);
}

void SSTryAdd_RefSet(SS *pb,int sol[],int value)
/* If solution sol qualifies, it is added to RefSet 
   (the worst one is replaced) */
{
	int i,j,worst_index;

	worst_index=pb->rs->order[pb->rs->b];
	if(!SSIsInRefSet(pb,sol) && value>pb->rs->ObjVal[worst_index])
	{
		/* Find position i for sol. insertion */
		i=pb->rs->b;
		while(i>=1 && value>pb->rs->ObjVal[pb->rs->order[i]])
			i--;
		i++;

		/* Replace solution */
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[worst_index][j]=sol[j];
		pb->rs->ObjVal[worst_index]=value;
		pb->rs->iter[worst_index]=pb->CurrentIter;

		/* Update RefSet order */
		for(j=pb->rs->b;j>i;j--)
			pb->rs->order[j]=pb->rs->order[j-1];
		pb->rs->order[i]=worst_index;

		pb->rs->NewSolutions=1;
	}
}

void SSCombine_nsol(SS *pb,int nsol,int *sols,int values[],int newsol[])
{
	int i,j,k,a,find,max,nmax;
	int *index;	 /* Indexes in sols of their incipient element */
	int *vote;	 /* Votes of elements */
	int *assign; /* Assigned elements */
	int *ties;	 /* Indexes with maximum vote */
	int *v_order;

	vote	= SSInt_array(pb->nvar);
	index	= SSInt_array(nsol);
	ties	= SSInt_array(nsol);
	assign  = SSInt_array(pb->nvar);

	for(i=1;i<=nsol;i++) index[i]=1;

	/* Order solutions according to value */
	v_order = SSOrder_i(values,nsol,1);

	for(i=1;i<=pb->nvar;i++)
	{
		/* Initialize votes */
		for(j=1;j<=pb->nvar;j++)
			vote[j]=0;

		/* Compute the votes and their max. */
		max=0;
		for(j=1;j<=nsol;j++)
		{
			if(index[j]<=pb->nvar)
			{
				a=pb->rs->sol[sols[j]][index[j]];
				vote[a] += 1+i-index[j];
			
				if(vote[a]>max)
					max = vote[a];
			}
		}

		/* Compute the ties */
		nmax=0;
		for(a=1;a<=pb->nvar;a++)
			if(vote[a]==max)
				ties[++nmax]=a;

		if(nmax==1) /* One single max, */
			a=ties[1];
		else		/* Tie breaking */
		{
			find=0;j=1;
			while(!find)
			{
				for(k=1;k<=nmax;k++)
					if(!find && pb->rs->sol[sols[v_order[j]]][index[j]]==ties[k])
					{
						find=1;
						a=ties[k];
					}
				j++;
			}
		}
		assign[a]=1;
		newsol[i]=a;

		/* Update the indexes of the incumbent elements */
		for(j=1;j<=nsol;j++)
			while(index[j]<=pb->nvar && assign[pb->rs->sol[sols[j]][index[j]]])
				index[j]++;
	}
	free(assign+1);
	free(vote+1);
	free(index+1);
	free(ties+1);
}

void SSPrint_RefSet(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("RefSet3.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->rs->b;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d    ",pb->rs->ObjVal[pb->rs->order[i]]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->rs->sol[pb->rs->order[i]][j]);
	}
	fclose(pf);
}



